﻿using System;

class DivideByZeroExceptionHandling
{
    static void Main(string[] args)
    {
        Boolean continueLoop = true;
        do
        {
            try
            {
                Console.WriteLine(); //empty line
                //10-3-23 JGoetz NEW 4L: input a numerator and denominator
                Console.Write("Enter an integer numerator: ");
                int numerator = int.Parse(Console.ReadLine());

                Console.Write("Enter an integer denominator: ");
                int denominator = int.Parse(Console.ReadLine());

                //10-3-23 JGoetz NEW 1L: calculation
                int result = numerator / denominator;

                //10-3-23 JGoetz NEW 1L: display results
                Console.WriteLine($"\nResult: numerator / denominator = {numerator} / {denominator} = {result}");
                
                continueLoop = false;
            }

            //10-3-23 JGoetz  NEW 13L: error handling for Format and Divide by Zero
            catch (FormatException formatException)
            {

                Console.WriteLine($" \n{formatException.Message}");
                Console.WriteLine("You must enter two integers.");
            }


            catch (DivideByZeroException divideByZeroException)
            {
                Console.WriteLine($" \n{divideByZeroException.Message}");
                Console.WriteLine($" \n{divideByZeroException.ToString()}");
                Console.WriteLine(); //empty line
                Console.WriteLine($" \n{divideByZeroException.StackTrace}");
                Console.WriteLine("Zero is an invalid denominator. Please try it again");

            }
        } while (continueLoop);
    }

} // end DivideByZeroExceptionHandling
